<?php

namespace App\Http\Controllers\Admin;

use App\Models\Frontend;
use App\Http\Controllers\Controller;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;
use App\Models\Banner;
use Illuminate\Validation\Rule;

class BannerController extends Controller
{
    public function index()
    {
        $pageTitle = "All Banner List";
        $plans = Banner::orderBy('id','asc')->paginate(getPaginate());
        return view('admin.banner.index', compact('pageTitle', 'plans'));
    }

    public function create()
    {
        $pageTitle = "Banner Create";
        return view('admin.banner.create', compact('pageTitle'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'image' => ['nullable','image',new FileTypeValidate(['jpg','jpeg','png'])]
        ]);

        $filename = null;
        if ($request->hasFile('image')) {
            try {
                $filename = fileUploader($request->image,getFilePath('banner'));
            } catch (\Exception $exp) {
                $notify[] = ['errors', 'Image could not be uploaded'];
                return back()->withNotify($notify);
            }
        }

        $plan = new Banner();
        $plan->title = $request->title;
        $plan->image = $filename;
        // dd($plan);
        $plan->save();
    	$notify[] = ['success', 'Banner added Successfully'];
        return back()->withNotify($notify);
    }

    public function edit($id)
    {
    	$plan = Banner::findOrFail($id);
    	$pageTitle = "Banner Update";
    	return view('admin.banner.edit', compact('pageTitle', 'plan'));
    }

    public function update(Request $request, $id)
    {
    	$request->validate([
    	 	'title' => 'required',
    	 	'image' => ['nullable','image',new FileTypeValidate(['jpg','jpeg','png'])]
    	]);
    	$plan = Banner::findOrFail($id);
        $filename = $plan->image;
        if ($request->hasFile('image')) {
            try {
                $filename = fileUploader($request->image,getFilePath('banner'),old:$filename);
            } catch (\Exception $exp) {
                $notify[] = ['errors', 'Image could not be uploaded'];
                return back()->withNotify($notify);
            }
        }

    	$plan->title = $request->title;
    	$plan->image = $filename;
    	$plan->save();
    	$notify[] = ['success', 'Banner updated successfully'];
    	return back()->withNotify($notify);
    }
}
