@extends('admin.layouts.app')
@section('panel')
<div class="row mb-none-30">
    <div class="col-lg-12">
        <form action="{{ route('admin.banner.store') }}" method="POST"  enctype="multipart/form-data">
            @csrf
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-lg-4">
                            <label>@lang('Title')</label>
                            <input type="text" class="form-control form-control-lg" name="title"
                                value="{{ old('title') }}" required="">
                        </div>

                        <div class="col-xxl-4 col-lg-6">
                            <div class="form-group">
                                <label>@lang('Image')</label>
                               <div class="gateway-thumb">
                                    <div class="thumb">
                                        <x-image-uploader image="/" class="w-100" type="banner" :required=false />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Banner Create')</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('breadcrumb-plugins')
<x-back route="{{ route('admin.banner.index') }}" />
@endpush
