@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th>@lang('Category')</th>
                                    <th>@lang('Title')</th>
                                    <th>@lang('Description')</th>
                                    <th>@lang('Image')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                            @forelse($content as $method)
                                <tr>
                                    <td>{{__($method->category)}}</td>
                                    <td>{{__($method->title)}}</td>
                                    <td>{{ \Illuminate\Support\Str::limit(strip_tags($method->description), 50, '...') }}</td>

                                    <td>
                                        <div class="user">
                                            <div class="thumb"><img src="{{ getImage(getFilePath('content').'/'. $method->image)}}" alt="@lang('image')"></div>
                                            <span class="name">{{__($method->name)}}</span>
                                        </div>
                                    </td>

                                  
                                    <td>
                                        <div class="button--group">
                                            <a href="{{ route('admin.content.edit', $method->id)}}"
                                               class="btn btn-sm btn-outline--primary ms-1"><i class="las la-pen"></i>@lang('Edit')</a>
                                           
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>
    <x-confirmation-modal />
@endsection



@push('breadcrumb-plugins')
    <div class="input-group w-auto search-form">
        <input type="text" name="search_table" class="form-control bg--white" placeholder="@lang('Search')...">
        <button class="btn btn--primary input-group-text"><i class="fas fa-search"></i></button>
    </div>
    <a class="btn btn-outline--primary" href="{{ route('admin.content.create') }}"><i class="las la-plus"></i>@lang('Add New')</a>
@endpush
