@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th>@lang('User')</th>
                                <th>@lang('Email-Mobile')</th>
                                <th>@lang('Country')</th>
                                <th>@lang('Joined At')</th>
                                <th>@lang('Balance')</th>
                                <th>@lang('Plan')</th>
                                <th>@lang('Action')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($users as $user)
                            <tr>
                                <td>
                                    <span class="fw-bold">{{$user->fullname}}</span>
                                    <br>
                                    <span class="small">
                                        <a href="{{ route('admin.users.detail', $user->id) }}">
                                            <span>@</span>{{ $user->username }}
                                        </a>
                                    </span>
                                </td>

                                <td>
                                    {{ $user->email }}<br>{{ $user->mobileNumber }}
                                </td>

                                <td>
                                    <span class="fw-bold" title="{{ @$user->country_name }}">{{ $user->country_code }}</span>
                                </td>

                                <td>
                                    {{ showDateTime($user->created_at) }} <br> {{ diffForHumans($user->created_at) }}
                                </td>

                                <td>
                                    <span class="fw-bold">{{ showAmount($user->balance) }}</span>
                                </td>

                                {{-- Show Plan --}}
                                <td>
                                    @if($user->plan_id && $user->plan)
                                        <span class="badge bg-success">{{ $user->plan->name }}</span>
                                    @else
                                        <span class="badge bg-danger">@lang('No Plan')</span>
                                    @endif
                                </td>

                                <td>
                                    <div class="button--group">
                                        <a href="{{ route('admin.users.detail', $user->id) }}" class="btn btn-sm btn-outline--primary">
                                            <i class="las la-desktop"></i> @lang('Details')
                                        </a>

                                        @if (request()->routeIs('admin.users.kyc.pending'))
                                            <a href="{{ route('admin.users.kyc.details', $user->id) }}" target="_blank" class="btn btn-sm btn-outline--dark">
                                                <i class="las la-user-check"></i>@lang('KYC Data')
                                            </a>
                                        @endif

                                        {{-- Add Plan button if no plan --}}
                                        @if(!$user->plan_id)
                                            <button type="button" class="btn btn-sm btn-outline--success addPlanBtn"
                                                    data-id="{{ $user->id }}">
                                                <i class="las la-plus"></i> @lang('Add Plan')
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>

                @if ($users->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($users) }}
                    </div>
                @endif
            </div>
        </div>

        {{-- Assign Plan Modal --}}
        <div class="modal fade" id="addPlanModal" tabindex="-1" aria-labelledby="addPlanModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form action="{{ route('admin.users.assign.plan') }}" method="POST">
                        @csrf
                        <input type="hidden" name="user_id" id="planUserId">

                        <div class="modal-header">
                            <h5 class="modal-title" id="addPlanModalLabel">@lang('Assign Plan')</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <div class="modal-body">
                            <div class="form-group">
                                <label>@lang('Select Plan')</label>
                                <select name="plan_id" class="form-control" required>
                                    <option value="">@lang('Select One')</option>
                                    @foreach(\App\Models\Plan::all() as $plan)
                                        <option value="{{ $plan->id }}">{{ $plan->name }} - {{ showAmount($plan->price) }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('Cancel')</button>
                            <button type="submit" class="btn btn--success">@lang('Assign Plan')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Username / Email" />
@endpush

@push('script')
<script>
    $('.addPlanBtn').on('click', function () {
        let userId = $(this).data('id');
        $('#planUserId').val(userId);
        $('#addPlanModal').modal('show');
    });
</script>
@endpush
