<header class="site-header">
    <div class="container">
        <div class="header-inner d-flex align-items-center justify-content-between">

            <!-- Logo -->
            <div class="header-logo">
                <a href="{{ route('home') }}">
                    <img src="{{ siteLogo() }}" alt="logo">
                </a>
            </div>

            <!-- Navigation -->
            <nav class="header-nav d-none d-lg-block">
                <ul class="nav-list d-flex align-items-center">
    <li>
        <a href="{{ route('home') }}" class="{{ request()->routeIs('home') ? 'active' : '' }}">@lang('Home')</a>
    </li>

    @foreach ($pages as $data)
        <li>
            <a href="{{ route('pages', [$data->slug]) }}" 
               class="{{ request()->is('pages/'.$data->slug) ? 'active' : '' }}">
               {{ __($data->name) }}
            </a>
        </li>
    @endforeach

    <li><a href="{{ route('plan') }}" class="{{ request()->routeIs('plan') ? 'active' : '' }}">@lang('Plan')</a></li>
    <li><a href="{{ route('blog') }}" class="{{ request()->routeIs('blog') ? 'active' : '' }}">@lang('Blog')</a></li>
    <li><a href="{{ route('contact') }}" class="{{ request()->routeIs('contact') ? 'active' : '' }}">@lang('Contact')</a></li>
</ul>

            </nav>

            <!-- Right Side -->
            <div class="header-right d-flex align-items-center gap-3">
                <!-- Language Switcher -->
                @if (gs('multi_language'))
                    @php
                        $language = App\Models\Language::all();
                        $selectLanguage = App\Models\Language::where('code', session('lang'))->first();
                    @endphp
                    <div class="dropdown language-switcher">
                        <button class="btn dropdown-toggle d-flex align-items-center gap-2" data-bs-toggle="dropdown">
                            <img src="{{ getImage(getFilePath('language') . '/' . $selectLanguage->image) }}" class="lang-flag" alt="flag">
                            <span>{{ __($selectLanguage->name) }}</span>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            @foreach ($language as $item)
                                <li>
                                    <a class="dropdown-item langSel d-flex align-items-center gap-2" data-code="{{ $item->code }}">
                                        <img src="{{ getImage(getFilePath('language') . '/' . $item->image) }}" class="lang-flag" alt="flag">
                                        {{ __($item->name) }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Auth Buttons -->
                @guest
                    <a href="{{ route('user.login') }}" class="btn btn-primary">@lang('Sign In')</a>
                @endguest

                @auth
                    <a href="{{ route('user.home') }}" class="btn btn-primary">@lang('Dashboard')</a>
                @endauth

                <!-- Mobile Menu Toggle -->
                <button class="header-toggle d-lg-none">
                    <i class="las la-bars"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Mobile Nav -->
    <div class="mobile-nav d-lg-none">
        <ul class="mobile-nav-list">
    <li><a href="{{ route('home') }}" class="{{ request()->routeIs('home') ? 'active' : '' }}">@lang('Home')</a></li>
    @foreach ($pages as $data)
        <li><a href="{{ route('pages', [$data->slug]) }}" 
               class="{{ request()->is('pages/'.$data->slug) ? 'active' : '' }}">
               {{ __($data->name) }}
            </a>
        </li>
    @endforeach
    <li><a href="{{ route('plan') }}" class="{{ request()->routeIs('plan') ? 'active' : '' }}">@lang('Plan')</a></li>
    <li><a href="{{ route('blog') }}" class="{{ request()->routeIs('blog') ? 'active' : '' }}">@lang('Blog')</a></li>
    <li><a href="{{ route('contact') }}" class="{{ request()->routeIs('contact') ? 'active' : '' }}">@lang('Contact')</a></li>
</ul>

    </div>
</header>


@push('script')
    <script>
        $(document).ready(function() {
            const $mainlangList = $(".langList");
            const $langBtn = $(".language-content");
            const $langListItem = $mainlangList.children();

            $langListItem.each(function() {
                const $innerItem = $(this);
                const $languageText = $innerItem.find(".language_text");
                const $languageFlag = $innerItem.find(".language_flag");

                $innerItem.on("click", function(e) {
                    $langBtn.find(".language_text_select").text($languageText.text());
                    $langBtn.find(".language_flag").html($languageFlag.html());
                });
            });
        });
    </script>
@endpush
@push('script')
<script>
    document.querySelector('.header-toggle').addEventListener('click', function() {
        document.querySelector('.mobile-nav').classList.toggle('d-block');
    });
</script>
@endpush

@push('style')
    <style>
        /* Active Link Styling */
.nav-list li a.active,
.mobile-nav-list li a.active {
    background: #f99f0b !important;
    color: #fff !important;
    border-radius: 6px;
    padding: 10px 16px;
}

      /* Header Base */
.site-header {
    background: #000;
    color: #fff;
    
    position: sticky;
    top: 0;
    z-index: 1000;
}

/* Logo */
.header-logo img {
    height: 100px;
}

/* Navigation */
.nav-list {
    list-style: none;
    gap: 24px;
    margin: 0;
    padding: 0;
}
.nav-list li a {
    color: #fff;
    font-weight: 500;
    transition: color .2s ease;
}
.nav-list li a:hover {
    padding:10px;
    background:#e58900;
    color: #fff;
}

/* Language Switcher */
.language-switcher .btn {
    background: transparent;
    color: #fff;
    border: none;
    font-size: 14px;
}
.lang-flag {
    height: 20px;
    width: 20px;
    border-radius: 50%;
    object-fit: cover;
}
.dropdown-menu {
    background: #124656;
    border-radius: 8px;
    border: 1px solid rgba(255,255,255,0.1);
}
.dropdown-item {
    color: #fff;
}
.dropdown-item:hover {
    background: #f99f0b;
    color: #fff;
}

/* Buttons */
.btn-primary {
    background: #f99f0b;
    border: none;
    padding: 6px 16px;
    border-radius: 6px;
    font-weight: 500;
    color: #fff;
}
.btn-primary:hover {
    background: #e58900;
}

/* Mobile Nav */
.header-toggle {
    background: transparent;
    border: none;
    font-size: 26px;
    color: #fff;
}
.mobile-nav {
    background: #000;
    display: none;
    padding: 10px 0;
}
.mobile-nav-list {
    list-style: none;
    margin: 0;
    padding: 0;
}
.mobile-nav-list li {
    border-bottom: 1px solid rgba(255,255,255,0.1);
}
.mobile-nav-list li a {
    
    display: block;
    padding: 12px 20px;
    color: #fff;
}
.mobile-nav-list li a:hover {
    background: #f99f0b;
}

    </style>
@endpush
