<header class="header-section">
    <div class="container">
        <div class="header-wrapper" style="padding:0px">
            <div class="logo">
                <a href="{{ route('home') }}">
                    <img src="{{ siteLogo() }}" alt="logo" style="height:100px;">
                </a>
            </div>
            <ul class="menu">
                <li>
                    <a href="{{ route('user.home') }}">@lang('Dashboard')</a>
                </li>

                <li class="menu-item-has-children">
                    <a href="javascript:void(0)">@lang('Deposit')</a>
                    <ul class="submenu">
                        <li>
                            <a href="{{route('user.deposit.index')}}">@lang('Deposit Money')</a>
                        </li>
                        <li>
                            <a href="{{route('user.deposit.history')}}">@lang('Deposit History')</a>
                        </li>
                    </ul>
                </li>

                <li class="menu-item-has-children">
                    <a href="javascript:void(0)">@lang('Withdraw')</a>
                    <ul class="submenu">
                        <li>
                            <a href="{{route('user.withdraw')}}">@lang('Withdraw Money')</a>
                        </li>
                        <li>
                            <a href="{{route('user.withdraw.history')}}">@lang('Withdraw History')</a>
                        </li>
                    </ul>
                </li>

                <li>
                    <a href="{{ route('plan') }}">@lang('Plan')</a>
                </li>

                <li>
                    <a href="{{ route('user.transactions') }}">@lang('Transactions')</a>
                </li>

                <li class="menu-item-has-children">
                    <a href="javascript:void(0)">@lang('Referrals')</a>
                    <ul class="submenu">
                        <li>
                            <a href="{{route('user.referral.log')}}">@lang('Referred Users')</a>
                        </li>

                        <li>
                            <a href="{{route('user.referral.commissions')}}">@lang('Referrals Commissions')</a>
                        </li>

                        <li>
                            <a href="{{route('user.level.commissions')}}">@lang('Level Commissions')</a>
                        </li>
                    </ul>
                </li>

                <li class="menu-item-has-children">
                    <a href="javascript:void(0)">Account</a>
                    <ul class="submenu">
                        <li>
                            <a href="{{ route('user.profile.setting') }}">@lang('Profile Setting')</a>
                        </li>
                        @if (gs('balance_transfer') == 1)
                            <li>
                                <a href="{{ route('user.balance.transfer') }}">@lang('Balance Transfer')</a>
                            </li>
                        @endif

                        @if (gs('epin_status') == 1)
                            <li>
                                <a href="{{ route('user.epin.recharge') }}">@lang('E-Pin Recharge')</a>
                            </li>
                            <li>
                                <a href="{{ route('user.recharge.log') }}">@lang('Recharge Log')</a>
                            </li>
                        @endif

                        <li>
                            <a href="{{route('user.change.password')}}">@lang('Change Password')</a>
                        </li>

                        <li>
                            <a href="{{route('ticket.index')}}">@lang('Support Ticket')</a>
                        </li>

                        <li>
                            <a href="{{ route('user.twofactor') }}">@lang('2FA Security')</a>
                        </li>

                        <li>
                            <a href="{{ route('user.logout') }}">@lang('Logout')</a>
                        </li>
                    </ul>
                </li>
            </ul>

            <div class="header-bar ml-2 ml-md-4">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </div>
</header>
@push('style')
<style>
/* Active Links */
.nav-list li a.active,
.mobile-nav-list li a.active {
    background: #f99f0b;
    color: #fff !important;
    border-radius: 6px;
    padding: 8px 14px;
}

/* Header Base */
.header-section {
    background: #000;
    position: sticky;
    top: 0;
    z-index: 1000;
}

/* Logo */
.header-logo img {
    height: 80px;
}

/* Desktop Menu */
.nav-list {
    list-style: none;
    gap: 24px;
    margin: 0;
    padding: 0;
}
.nav-list li {
    position: relative;
}
.nav-list li a {
    color: #fff;
    font-weight: 500;
    transition: 0.3s;
}
.nav-list li a:hover {
    background: #e58900;
    padding: 8px 14px;
    border-radius: 6px;
    color: #fff;
}

/* Dropdown */
.dropdown .submenu {
    display: none;
    position: absolute;
    background: #111;
    min-width: 180px;
    border-radius: 6px;
    padding: 8px 0;
}
.dropdown:hover .submenu {
    display: block;
}
.submenu li a {
    display: block;
    padding: 8px 14px;
    color: #ddd;
}
.submenu li a:hover {
    background: #f99f0b;
    color: #fff;
}

/* Mobile */
.header-toggle {
    background: transparent;
    border: none;
    font-size: 26px;
    color: #fff;
}
.mobile-nav {
    background: #000;
    display: none;
}
.mobile-nav.active {
    display: block;
}
.mobile-nav-list {
    list-style: none;
    padding: 0;
}
.mobile-nav-list li {
    border-bottom: 1px solid rgba(255,255,255,0.1);
    position: relative;
}
.mobile-nav-list li a {
    display: block;
    padding: 12px 20px;
    color: #fff;
}
.mobile-nav-list li a:hover {
    background: #f99f0b;
}

/* Mobile Submenu Toggle */
.mobile-nav-list .submenu {
    display: none;
    background: #111;
}
.mobile-nav-list .submenu.show {
    display: block;
}
.mobile-nav-list .dropdown > a::after {
    content: "\25BC"; /* ▼ */
    float: right;
    font-size: 12px;
    margin-top: 5px;
}
</style>
@endpush

@push('script')
<script>
// Toggle mobile menu
document.querySelector('.header-toggle').addEventListener('click', function() {
    document.querySelector('.mobile-nav').classList.toggle('active');
});

// Toggle submenu inside mobile nav
document.querySelectorAll('.mobile-nav .dropdown > a').forEach(function(dropLink) {
    dropLink.addEventListener('click', function(e) {
        e.preventDefault(); // prevent page jump
        const submenu = this.nextElementSibling;
        submenu.classList.toggle('show');
    });
});
</script>
@endpush
