@extends($activeTemplate . 'layouts.frontend')
@section('content')
<section class="account-section d-flex align-items-center justify-content-center">
    <div class="account-card text-center">

        <!-- Logo -->
        <div class="mb-4">
            <a href="{{ route('home') }}" class="account-logo">
                <img src="{{ siteLogo() }}" alt="logo" class="login-logo">
            </a>
        </div>

        <!-- Form -->
        <form method="POST" action="{{ route('user.login') }}" class="login-form verify-gcaptcha">
            @csrf
            <h3 class="mb-4 text-white">@lang('Sign In')</h3>

            <div class="form-group mb-3 text-start">
                <label class="form-label">@lang('Username or Email')</label>
                <input type="text" name="username" value="{{ old('username') }}" required class="form-control">
            </div>

            <div class="form-group mb-3 text-start">
                <label class="form-label">@lang('Password')</label>
                <input type="password" name="password" required class="form-control">
            </div>

            <x-captcha />

            <button type="submit" class="btn btn-primary w-100 mt-3">@lang('Sign In')</button>

            <div class="d-flex justify-content-between mt-3">
                <p class="m-0 text-white">@lang("Don't have an account?") 
                    <a href="{{ route('user.register') }}" class="">@lang('Sign Up')</a>
                </p>
                <a href="{{ route('user.password.request') }}" class="">@lang('Forgot Password?')</a>
            </div>
        </form>

        <!-- Footer -->
        <div class="mt-4">
            <p class="m-0 text-white">&copy; @lang('All Rights Reserved By') 
                <a href="{{ route('home') }}" class="">{{ __(gs('site_name')) }}</a>
            </p>
        </div>
    </div>
</section>
@endsection

@push('style')
<style>
.account-section {
    min-height: 100vh;
    background: #111; /* Dark background */
    padding: 20px;
}
.account-card {
    background: #000;
    padding: 50px 40px;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgba(0,0,0,0.5);
    max-width: 480px; /* slightly larger */
    width: 100%;
}
.login-logo {
    height: 70px;
}
.form-label {
    font-weight: 500;
    color: #fff;
    margin-bottom: 6px;
}
.login-form .form-control {
    border-radius: 8px;
    padding: 12px 14px;
    border: 1px solid #444;
    background: #222;
    color: #fff;
}
.login-form .form-control:focus {
    border-color: #f99f0b;
    box-shadow: none;
    background: #1a1a1a;
    color: #fff;
}
.btn-primary {
    background: #f99f0b;
    border: none;
    padding: 12px;
    border-radius: 8px;
    font-weight: 600;
    color: #fff;
}
.btn-primary:hover {
    background: #e58900;
}
.text-theme {
    color: #f99f0b !important;
}
.text-theme:hover {
    text-decoration: underline;
}
</style>
@endpush
