@extends($activeTemplate . 'layouts.frontend')
@section('content')
@php
$policys = getContent('policy_pages.element', false, null, true);
@endphp
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/parsleyjs/src/parsley.css">

<section class="account-section d-flex align-items-center justify-content-center">
    <div class="account-card text-center">

        <!-- Logo -->
        <div class="mb-4">
            <a href="{{ route('home') }}" class="account-logo">
                <img src="{{ siteLogo() }}" alt="logo" class="login-logo">
            </a>
        </div>

        <!-- Register Form -->
       <form class="login-form verify-gcaptcha" action="{{ route('user.register') }}" method="POST" id="registerForm" data-parsley-validate>
            @csrf
            <h3 class="mb-4 text-white">@lang('Create Account')</h3>

            <div class="row">
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">@lang('First Name')</label>
                    <input type="text" name="firstname" value="{{ old('firstname') }}" required class="form-control" data-parsley-required-message="First name is required">
                </div>
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">@lang('Last Name')</label>
                    <input type="text" name="lastname" value="{{ old('lastname') }}" required class="form-control" data-parsley-required-message="Last name is required">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">@lang('E-Mail Address')</label>
                    <input type="email" name="email" value="{{ old('email') }}" required class="form-control checkUser" data-parsley-type="email" data-parsley-required-message="Valid email is required">
                </div>
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">@lang('Mobile')</label>
                    <input type="number" name="mobile" value="{{ old('mobile') }}" required class="form-control checkUser" data-parsley-type="digits" data-parsley-minlength="10" data-parsley-required-message="Mobile number is required">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">@lang('Password')</label>
                    <input type="password" name="password" required minlength="6" class="form-control @if (gs('secure_password')) secure-password @endif"
                        data-parsley-required-message="Password is required"
                        data-parsley-minlength="6"
                        data-parsley-minlength-message="Password must be at least 6 characters">
                </div>
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">@lang('Confirm Password')</label>
                    <input type="password" name="password_confirmation" required class="form-control"
                        data-parsley-equalto="[name=password]" 
                        data-parsley-required-message="Please confirm your password"
                        data-parsley-equalto-message="Passwords do not match">
                </div>
            </div>

            @if (session()->get('reference'))
            <div class="form-group mb-3 text-start">
                <label class="form-label">@lang('Reference By')</label>
                <input type="text" name="referBy" value="{{ session()->get('reference') }}" readonly class="form-control">
            </div>
            @else
            <div class="form-group mb-3 text-start">
                <label class="form-label">@lang('Reference By')(Optional)</label>
                <input type="text" name="referBy" value="{{ old('referBy') }}" class="form-control">
            </div>
            @endif

            <x-captcha />

            @if (gs('agree'))
            <div class="form-group text-start mt-3">
                <input id="check" name="agree" type="checkbox" class="form-check" required data-parsley-required-message="You must agree before signing up">
                <label for="check" class="form-label">
                    @lang('I agree with')
                    @foreach ($policys as $policy)
                        <a class="" href="{{ route('policy.pages', [slug($policy->data_values->title), $policy->id]) }}">{{ __($policy->data_values->title) }}</a>@if (!$loop->last), @endif
                    @endforeach
                </label>
            </div>
            @endif

            <button type="submit" class="btn btn-primary w-100 mt-3">@lang('Sign Up')</button>

            <p class="mt-3 text-white">@lang('Already have an account?')
                <a href="{{ route('user.login') }}" class="">@lang('Sign In')</a>
            </p>
        </form>

        <!-- Footer -->
        <div class="mt-4">
            <p class="m-0 text-white">&copy; @lang('All Rights Reserved By')
                <a href="{{ route('home') }}" class="">{{ __(gs('site_name')) }}</a>
            </p>
        </div>
    </div>
</section>
@endsection
@push('style')
<style>
    .account-section {
        min-height: 100vh;
        background: #111;
        padding: 20px;
    }

    .account-card {
        background: #000;
        padding: 50px 40px;
        border-radius: 12px;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.5);
        max-width: 520px;
        width: 100%;
    }

    .login-logo {
        height: 70px;
    }

    .form-label {
        font-weight: 500;
        color: #fff;
        margin-bottom: 6px;
    }

    .login-form .form-control {
        border-radius: 8px;
        padding: 12px 14px;
        border: 1px solid #444;
        background: #222;
        color: #fff;
    }

    .login-form .form-control:focus {
        border-color: #f99f0b;
        background: #1a1a1a;
        color: #fff;
        box-shadow: none;
    }

    .btn-primary {
        background: #f99f0b;
        border: none;
        padding: 12px;
        border-radius: 8px;
        font-weight: 600;
        color: #fff;
    }

    .btn-primary:hover {
        background: #e58900;
    }

    .text-theme {
        color: #f99f0b !important;
    }

    .text-theme:hover {
        text-decoration: underline;
    }

    /* ✅ Make checkbox smaller */
    .form-check {
        width: auto;
        display: inline-block;
        vertical-align: middle;
    }

    .form-check input[type="checkbox"] {
        width: 16px;
        height: 16px;
        cursor: pointer;
        margin-right: 6px;
    }

</style>
@endpush
@push('script')
<!-- jQuery (latest version from Google CDN) -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<!-- ✅ Include Parsley.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
<script>
    // Init parsley
    $('#registerForm').parsley();
</script>
@endpush