@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="transaction-section padding-top padding-bottom">
        <div class="container">
            <div class="primary-bg item-rounded">
                <table class="deposite-table">
                    <thead class="custom--table">
                        <tr>
                            <th>@lang('User')</th>
                            <th>@lang('TRX')</th>
                            <th>@lang('Amount')</th>
                            <th>@lang('Post Balance')</th>
                            <th>@lang('Date')</th>
                            <th>@lang('Detail')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($commissions as $commission)
                            <tr>
                                <td>{{ $commission->user->username }}</td>
                                <td>{{ $commission->trx }}</td>
                                <td class="budget">
                                    <strong class="text--success">+ {{ showAmount($commission->amount) }}
                                    </strong>
                                </td>
                                <td>{{ showAmount($commission->post_balance) }}
                                </td>
                                <td>
                                    {{ showDateTime($commission->created_at) }}
                                    <br>
                                    {{ diffForHumans($commission->created_at) }}
                                </td>
                                <td>{{ __($commission->details) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                <div class="paginate-wrapper">
                    {{ paginateLinks($commissions) }}
                </div>
            </div>
        </div>
    </div>
@endsection
