@extends($activeTemplate . 'layouts.' . $layout)
@section('content')
    <div class="message__chatbox-section padding-top-half padding-bottom">
        <div class="container">
            <div class="message__chatbox">
                <div class="message__chatbox__header">
                    <h5 class="title text-white">
                        @php echo $myTicket->statusBadge; @endphp

                        @lang('Ticket ID'):<span class="cl-theme">[#{{ $myTicket->ticket }}] {{ $myTicket->subject }}</span>
                    </h5>
                    @if ($myTicket->status != Status::TICKET_CLOSE && $myTicket->user)
                        <a class="btn btn--sm d-block btn--danger confirmationBtn text-center"
                            data-action="{{ route('ticket.close', $myTicket->id) }}" data-question="@lang('Are you sure you want to close this support ticket?')"
                            href="javascript:void(0)">@lang('Close Ticket')</a>
                    @endif
                </div>

                <div class="message__chatbox__body">
                    <form class="disableSubmission" method="post" action="{{ route('ticket.reply', $myTicket->id) }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="row justify-content-between">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <textarea class="form-control form--control" name="message" rows="4" required>{{ old('message') }}</textarea>
                                </div>
                            </div>

                            <div class="col-md-9">
                                <button class="btn btn--base btn-sm addAttachment my-2" type="button"> <i
                                        class="fas fa-plus"></i> @lang('Add Attachment') </button>
                                <p class="mb-2"><span class="text--white mt-2 d-block">@lang('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx')</span></p>
                                <div class="row fileUploadsContainer">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn--base w-100 my-2" type="submit"><i
                                        class="la la-fw la-lg la-reply"></i> @lang('Reply')
                                </button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="message__chatbox-section padding-bottom">
        <div class="container">
            <div class="message__chatbox">
                <div class="message__chatbox__body">
                    <ul class="reply-message-area">
                        @foreach ($messages as $message)
                            <li>
                                @if ($message->admin_id == 0)
                                    <div class="reply-item">
                                        <div class="name-area">
                                            <h6 class="title">{{ __($message->ticket->name) }}</h6>
                                        </div>
                                        <div class="content-area">
                                            <span class="meta-date">
                                                @lang('Posted on') <span
                                                    class="cl-theme">{{ $message->created_at->format('l, dS F Y @ H:i') }}</span>
                                            </span>
                                            <p>
                                                {{ __($message->message) }}
                                            </p>
                                            @if ($message->attachments->count() > 0)
                                                <div class="mt-2">
                                                    @foreach ($message->attachments as $k => $image)
                                                        <a class="mr-3"
                                                            href="{{ route('ticket.download', encrypt($image->id)) }}"><i
                                                                class="fa fa-file"></i> @lang('Attachment')
                                                            {{ ++$k }} </a>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @else
                                    <ul>
                                        <li>
                                            <div class="reply-item">
                                                <div class="name-area">
                                                    <div class="reply-thumb">
                                                        <img src="{{ getImage('assets/admin/images/profile/' . $message->admin->image, '400x400') }}"
                                                            alt="@lang('Admin Image')">
                                                    </div>
                                                    <h6 class="title">{{ __($message->admin->name) }}</h6>
                                                </div>
                                                <div class="content-area">
                                                    <span class="meta-date">
                                                        @lang('Posted on'), <span
                                                            class="cl-theme">{{ $message->created_at->format('l, dS F Y @ H:i') }}</span>
                                                    </span>
                                                    <p>
                                                        {{ __($message->message) }}
                                                    </p>
                                                    @if ($message->attachments->count() > 0)
                                                        <div class="mt-2">
                                                            @foreach ($message->attachments as $k => $image)
                                                                <a class="mr-3"
                                                                    href="{{ route('ticket.download', encrypt($image->id)) }}"><i
                                                                        class="fa fa-file"></i>
                                                                    @lang('Attachment') {{ ++$k }} </a>
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                            </li>
                        @endif
                        @endforeach
                </div>
            </div>
        </div>
    </div>

    <x-confirmation-modal is_custom="yes" />
@endsection
@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }

        .reply-bg {
            background-color: #ffd96729
        }

        .empty-message img {
            width: 120px;
            margin-bottom: 15px;
        }
    </style>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-4 col-md-12 removeFileInput">
                        <div class="form-group">
                            <div class="input-group">
                                <input type="file" name="attachments[]" class="form-control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                                <button type="button" class="input-group-text cmn--form--control removeFile bg--danger border--danger"><i class="fas fa-times-circle"></i></button>
                            </div>
                        </div>
                    </div>
                `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
@endpush
